/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.io.efs;

import com.aptana.core.io.efs.Messages;
import com.aptana.core.io.vfs.IExtendedFileStore;
import com.aptana.core.util.ProgressMonitorInterrupter;
import com.aptana.ide.core.io.PermissionDeniedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public final class SyncUtils {
    private SyncUtils() {
    }

    public static void copy(IFileStore source, IFileInfo sourceInfo, IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = monitor == null ? new NullProgressMonitor() : monitor;
            SyncUtils.checkCanceled(monitor);
            monitor.beginTask("", sourceInfo == null ? 3 : 2);
            if (sourceInfo == null) {
                sourceInfo = source.fetchInfo(1024, SyncUtils.subMonitorFor(monitor, 1));
            }
            SyncUtils.checkCanceled(monitor);
            if (sourceInfo.isDirectory()) {
                destination.mkdir(0, SyncUtils.subMonitorFor(monitor, 2));
            } else {
                byte[] buffer = new byte[8192];
                long length = sourceInfo.getLength();
                int totalWork = length == -1L ? -1 : 1 + (int)(length / (long)buffer.length);
                InputStream in = null;
                OutputStream out = null;
                ProgressMonitorInterrupter interrupter = new ProgressMonitorInterrupter(monitor);
                try {
                    in = source.openInputStream(0, SyncUtils.subMonitorFor(monitor, 0));
                    out = destination.openOutputStream(0, SyncUtils.subMonitorFor(monitor, 0));
                    IProgressMonitor subMonitor = SyncUtils.subMonitorFor(monitor, 2);
                    subMonitor.beginTask(MessageFormat.format(Messages.SyncUtils_Copying, source.toString()), totalWork);
                    while (true) {
                        int bytesRead;
                        SyncUtils.checkCanceled(monitor);
                        try {
                            bytesRead = in.read(buffer);
                        }
                        catch (IOException e) {
                            bytesRead = -1;
                            SyncUtils.checkCanceled(monitor);
                            SyncUtils.error(MessageFormat.format(Messages.SyncUtils_ERR_Reading, source.toString()), e);
                        }
                        if (bytesRead == -1) break;
                        SyncUtils.checkCanceled(monitor);
                        try {
                            out.write(buffer, 0, bytesRead);
                        }
                        catch (IOException e) {
                            SyncUtils.checkCanceled(monitor);
                            SyncUtils.error(MessageFormat.format(Messages.SyncUtils_ERR_Writing, destination.toString()), e);
                        }
                        subMonitor.worked(1);
                    }
                    subMonitor.done();
                }
                catch (Throwable throwable) {
                    interrupter.dispose();
                    SyncUtils.safeClose(in);
                    SyncUtils.safeClose(out);
                    throw throwable;
                }
                interrupter.dispose();
                SyncUtils.safeClose(in);
                SyncUtils.safeClose(out);
            }
            try {
                if (destination instanceof IExtendedFileStore) {
                    destination.putInfo(sourceInfo, 0xC00 | options, SyncUtils.subMonitorFor(monitor, 1));
                }
            }
            catch (CoreException e) {
                if (!(e.getCause() instanceof PermissionDeniedException)) {
                    throw e;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    private static void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static void error(String message, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", message, (Throwable)e));
    }

    private static void safeClose(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ignore) {
            ignore.getCause();
        }
    }

    private static void safeClose(OutputStream out) throws CoreException {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.SyncUtils_ERR_FailToClose, (Throwable)e));
        }
    }
}

